local sBannerPath = THEME:GetPathG("Common", "fallback jacket");
local sJacketPath = THEME:GetPathG("Common", "fallback jacket");
local bAllowJackets = true
local song;
local group;

local t = Def.ActorFrame {
	LoadActor("under")..{
		InitCommand=cmd(zoom,0.815);
		SetMessageCommand=function(self, params)
			local song = params.Song;
		if song then
			local group_colors= {
				["DanceDanceRevolution 1stMIX"]= "#99FF66",
				["DanceDanceRevolution 2ndMIX"]= "#FF6633",
				["DanceDanceRevolution 3rdMIX + VER.Korea"]= "#FFFF66",
				["DanceDanceRevolution 4thMIX"]= "#CC66FF",
				["DanceDanceRevolution 5thMIX"]= "#66CCFF",
				["DanceDanceRevolution 6thMIX MAX"]= "#FF9900",
				["DanceDanceRevolution 7thMIX MAX2"]= "#FF3333",
				["DanceDanceRevolution 8thMIX EXTREME"]= "#00CC33",
				["DanceDanceRevolution SuperNOVA"]= "#CC0000",
				["DanceDanceRevolution SuperNOVA2"]= "#33CCFF",
				["DanceDanceRevolution X"]= "#FF9933",
				["DanceDanceRevolution X2"]= "#FF33CC",
				["DanceDanceRevolution X3"]= "#3366FF",
				["DDR"]= "#33FF99",
				["DDR2014"]= "#33FF99",
				["Next Generation"]= "#FFFFFF",
				["NG Extra 1"]= "#FF0000",
				["NG Extra 2"]= "#FF0000",
			}
			local color_str= group_colors[song:GetGroupName()] or "#FFFFFF"
			self:diffusebottomedge(color(color_str))
			self:diffusealpha(1)
		end;
	end;
};
	LoadActor("title")..{
	InitCommand=cmd(zoom,0.815);
	};
	Def.Sprite {
		Name="Banner";
		InitCommand=cmd(scaletoclipped,220,220);
		BannerCommand=cmd(scaletoclipped,220,220);
		JacketCommand=cmd(scaletoclipped,220,220);
		-- Set em up the graphics.
		SetMessageCommand=function(self,params)
			local Song = params.Song;
			local Course = params.Course;
			-- We have a song, not course
			if Song then
				-- Have Jacket
				if ( Song:GetJacketPath() ~=  nil ) and ( bAllowJackets ) then
					self:Load( Song:GetJacketPath() );
					self:playcommand("Jacket");
				-- Use Background if we want Jackets
				elseif ( Song:GetBackgroundPath() ~= nil ) and ( bAllowJackets ) then
					self:Load( Song:GetBackgroundPath() );
					self:playcommand("Jacket");
				-- Use Banner if we dont care 
				elseif ( Song:GetBannerPath() ~= nil ) then
					self:Load( Song:GetBannerPath() );
					self:playcommand("Banner");
				-- Use Default
				else
				  self:Load( bAllowJackets and sBannerPath or sJacketPath );
				  self:playcommand( bAllowJackets and "Jacket" or "Banner" );
				end;
			elseif Course then
				-- We have a background (for jackets) 
				if ( Course:GetBackgroundPath() ~= nil ) and ( bAllowJackets ) then
					self:Load( Course:GetBackgroundPath() );
					self:playcommand("Jacket");
				-- We have a banner
				elseif ( Course:GetBannerPath() ~= nil ) then
					self:Load( Course:GetBannerPath() );
					self:playcommand("Banner");
				-- Get your defaults
				else
					self:Load( sJacketPath );
					self:playcommand( bAllowJackets and "Jacket" or "Banner" );
				end
			-- What the hell did you do?! 
			else
				self:Load( bAllowJackets and sJacketPath or sBannerPath );
				self:playcommand( bAllowJackets and "Jacket" or "Banner" );
			end;
		end;
	};
	LoadActor("NEW") .. {
		InitCommand=cmd(x,-66;y,-115;finishtweening;draworder,1;zoom,1.111);
		SetCommand=function(self,param)
			if param.Song then
				if PROFILEMAN:IsSongNew(param.Song) then
					self:visible(true);
				else
					self:visible(false);
				end
			else
				self:visible(false);
			end
		end;
	};
	
};
local u = Def.ActorFrame{};

local positions = {
	-80, -- beginner
	-40,  -- easy
	0,   -- medium
	40,   -- hard
	80,  -- expert
	180,  -- edit, which shouldn't be shown
};
local skew = {
	-2.625, -- beginner
	-1.3125,  -- easy
	0,   -- medium
	1.3125,   -- hard
	2.625,  -- expert
	31,  -- edit, which shouldn't be shown
};

for idx, diff in pairs(Difficulty) do -- 0, Difficulty_Beginner
	-- hack to hide edit
	if idx < 6 and not GAMESTATE:IsCourseMode() then
		u[#u+1] = LoadActor( "_DifficultyDisplay" ) .. {
			InitCommand=cmd(y,20;x,130;zoom,0.6;playcommand,"SetMessage");
			ShowCommand=cmd(visible,true);
			HideCommand=cmd(visible,false);
			BeginCommand=function(self)
				self:y(positions[idx]);
				self:diffuse(CustomDifficultyToColor(diff)); 
			end;

			SetMessageCommand=function(self,params)
				local song = params.Song;
				-- if there isn't a song, don't bother.
				if not song then return end;

				local st = GAMESTATE:GetCurrentStyle():GetStepsType();
				local bHasStepsTypeAndDifficulty =
					song and song:HasStepsTypeAndDifficulty( st, diff );

				self:playcommand( bHasStepsTypeAndDifficulty and "Show" or "Hide" );
			end;
		};
	end;
end;

t[#t+1] = u;
return t;
	
-- Cute overlay

	
	
